package ru.yandex.io.sdk.utils

import android.app.NotificationChannel
import android.app.NotificationManager
import android.app.Service
import android.content.Context
import android.os.Build
import androidx.annotation.DrawableRes
import androidx.annotation.RequiresApi
import androidx.core.app.NotificationCompat
import com.yandex.launcher.logger.KLogger
import ru.yandex.io.sdk.NotificationIds

class ForegroundServiceHelper(
    private val notificationChannelId: String,
    private val notificationChannelName: String
) {
    fun startForeground(service: Service) {
        try {
            startForegroundInternal(service)
        } catch (e: Throwable) {
            KLogger.e(TAG, e) { "Failed to startForeground YandexIoServiceImpl" }
        }
    }

    private fun startForegroundInternal(service: Service) {
        if (ProcessUtils.isRunningInForeground(service) == true) {
            KLogger.d(TAG) {
                "skip doStartForeground since service is already running in foreground"
            }
            return
        }
        KLogger.d(TAG) { "doStartForeground do postNotification" }
        val notificationId: Int = NotificationIds.KEEP_ALIVE_SERVICE_ID

        // suppress "blaming logic" in ServiceRecord.postNotification
        // could be any(?) icon since it isn't visible to user
        @DrawableRes val smallIconResId = android.R.drawable.ic_media_play
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.O) {
            createNotificationChannel(service)
            val foregroundNotification =
                NotificationCompat.Builder(service, notificationChannelId)
                    .setSmallIcon(smallIconResId)
                    .setOngoing(true)
                    .build()
            service.startForeground(notificationId, foregroundNotification)
        } else {
            val notification = NotificationCompat.Builder(service, notificationChannelId)
                .setSmallIcon(smallIconResId)
                .build()
            service.startForeground(notificationId, notification)
        }
    }

    @Suppress("SameParameterValue")
    @RequiresApi(api = Build.VERSION_CODES.O)
    private fun createNotificationChannel(ctx: Context) {
        val channel = NotificationChannel(
            notificationChannelId,
            notificationChannelName,
            NotificationManager.IMPORTANCE_NONE
        )
        (ctx.getSystemService(Context.NOTIFICATION_SERVICE) as NotificationManager)
            .createNotificationChannel(channel)
    }

    private companion object {
        const val TAG = "ForegroundServiceHelper"
    }
}
