package ru.yandex.io.sdk.utils

import android.app.ActivityManager
import android.app.Service
import android.content.Context
import android.os.Process
import com.yandex.launcher.logger.KLogger

object ProcessUtils {
    private const val TAG = "ProcessUtils"

    fun tryRaiseThreadPriority(targetPriority: Int) {
        tryRaiseThreadPriority(Process.myTid(), targetPriority)
    }

    fun tryRaiseThreadPriority(threadId: Int, targetPriority: Int) {
        val originalPriority = Process.getThreadPriority(threadId)
        var priorityToSet = targetPriority
        while (priorityToSet < originalPriority) {
            try {
                Process.setThreadPriority(threadId, priorityToSet)
                return
            } catch (e: Throwable) {
                // Some applications can not change the thread priority.
                // This catches that potential error and tries to set a lower priority.
                priorityToSet += Process.THREAD_PRIORITY_LESS_FAVORABLE
            }
        }
    }

    fun isRunningInForeground(service: Service): Boolean? {
        return isRunningInForeground(service, service.javaClass)
    }

    /**
     * @return null in case if failed to determine is service running in foreground or not
     */
    fun isRunningInForeground(
        context: Context, serviceClass: Class<*>
    ): Boolean? {
        val serviceName = serviceClass.name
        return try {
            val manager = context.getSystemService(Service.ACTIVITY_SERVICE) as ActivityManager
            val infos = manager.getRunningServices(Int.MAX_VALUE)
            for (service in infos) {
                if (serviceName == service.service.className) {
                    return service.foreground
                }
            }
            false
        } catch (e: Throwable) {
            KLogger.e(TAG, e) {
                "failed to determine is service running in foreground or not"
            }
            null
        }
    }
}
