package ru.yandex.io.sdk.utils

import com.yandex.launcher.logger.KLogger
import java.util.concurrent.ThreadFactory
import java.util.concurrent.atomic.AtomicInteger

object ThreadUtils {
    fun createNamedThreadFactory(name: String): ThreadFactory {
        return NamedThreadFactory(name)
    }

    private class NamedThreadFactory(
        private val name: String
    ) : ThreadFactory {
        private val threadNumber = AtomicInteger(1)

        override fun newThread(r: Runnable): Thread {
            val number = threadNumber.getAndIncrement()
            val threadName = "$name-$number"
            return object : Thread(r, threadName) {
                override fun run() {
                    val tag = "Thread($threadName)"
                    try {
                        super.run()
                    } catch (e: Throwable) {
                        KLogger.e(tag, e) { "run" }
                    }
                }
            }
        }
    }
}
