package ru.yandex.io.sdk.utils

import com.yandex.launcher.logger.Logger


inline fun <R> tryOrLog(
    tag: String,
    actionDescription: String,
    onThrow: (Throwable) -> R,
    action: () -> R
) = try {
    Logger.d(tag, "Attempt to $actionDescription")
    val result = action()
    Logger.d(tag, "Succeeded to $actionDescription")
    result
} catch (th: Throwable) {
    Logger.w(tag, "Fails to $actionDescription", th)
    onThrow(th)
}

inline fun <R> tryOrLog(
    tag: String,
    actionDescription: String,
    action: () -> R
) = tryOrLog(
    tag = tag,
    actionDescription = actionDescription,
    onThrow = { null },
    action = action
)
