package ru.yandex.io.sdk.utils

import com.google.protobuf.ByteString
import ru.yandex.io.sdk.BuildConfig
import java.io.IOException
import java.io.InputStream
import java.nio.ByteBuffer

fun isBetaOrDebug(): Boolean =
    when (BuildConfig.BUILD_TYPE) {
        "debug", "beta" -> true
        else -> false
    }

fun ByteBuffer.toByteString(): ByteString {
    val inputStream: InputStream = ByteBufferInputStream(this)
    try {
        return ByteString.readFrom(inputStream)
    } catch (exception: IOException) {
        throw RuntimeException(exception)
    }
}
