#pragma once

#include <span>

namespace YandexIO {
    class IAudioSink {
    public:
        virtual ~IAudioSink() = default;

        //! Prepare to get data with specified format
        virtual void start(int channels, int sampleRate, int sampleSize) = 0;
        //! Immediately pause playback
        virtual void pause() = 0;
        //! Resume paused playback
        virtual void resume() = 0;
        //! Immediately stop playback
        virtual void cancel() = 0;
        //! Stop playback after all send data played
        virtual void finish() = 0;
        //! Feed next chunk of sound data. Called only after start() calls
        virtual void pushData(std::span<const std::uint8_t> data) = 0;
    };
}
