#pragma once

#include <memory>

class LauncherConfig;

namespace YandexIO {
    class IAudioSink;

    class ILauncher {
    public:
        virtual ~ILauncher() = default;

        virtual void initialize(std::shared_ptr<const LauncherConfig> config) = 0;
        virtual void setAudioSink(std::shared_ptr<IAudioSink> audioSink) = 0;
        virtual void start() = 0;
    };
}
