#include "jni_alice_capability.h"
#include "jni_alice_capability_jni.h"

#include <alice/megamind/protos/speechkit/request.pb.h>

#include <yandex_io/capabilities/alice/interfaces/i_alice_capability.h>
#include <yandex_io/android_sdk/cpp/jni/jni_utils.cpp>
#include <yandex_io/android_sdk/libs/cpp/jni/jni_exception.h>
#include <yandex_io/libs/logging/logging.h>

YIO_DEFINE_LOG_MODULE("android_sdk");

namespace {
    static NJni::TCheckedPtr<std::shared_ptr<YandexIO::IAliceCapability>> alice;
}

namespace YandexIO {
    void setNativeAliceCapabilityInterface(std::shared_ptr<IAliceCapability> iface) {
        alice = std::move(iface);
    }

    IAliceCapability* getNativeAliceCapabilityInterfaceForTest() {
        return alice.Get();
    }
}

JNIEXPORT void JNICALL Java_com_yandex_io_JniAliceCapability_toggleConversation(JNIEnv* env, jobject) {
    NJni::Call(env, [] {
        alice->toggleConversation(YandexIO::VinsRequest::createHardwareButtonClickEventSource());
    });
}

JNIEXPORT void JNICALL Java_com_yandex_io_JniAliceCapability_startConversation(JNIEnv* env, jobject) {
    NJni::Call(env, [] {
        alice->startConversation(YandexIO::VinsRequest::createHardwareButtonClickEventSource());
    });
}

JNIEXPORT void JNICALL Java_com_yandex_io_JniAliceCapability_stopConversation(JNIEnv* env, jobject) {
    NJni::Call(env, [] {
        alice->stopConversation();
    });
}
