#pragma once

#include <jni.h>

namespace NJni {
    class TByteArray {
    public:
        TByteArray(JNIEnv* env, jbyteArray input)
            : Env(env)
            , Input(input)
            , Start(Env->GetByteArrayElements(Input, nullptr))
            , Length(Env->GetArrayLength(Input))
        {
        }

        ~TByteArray() {
            Env->ReleaseByteArrayElements(Input, Start, 0);
        }

        const jbyte* Data() const {
            return Start;
        }

        jsize Size() const {
            return Length;
        }

    private:
        JNIEnv* const Env;
        const jbyteArray Input;
        jbyte* const Start;
        const jsize Length;
    };

    class TByteBuffer {
    public:
        TByteBuffer(JNIEnv* env, jobject input)
            : Env(env)
            , Input(input)
            , Start(Env->GetDirectBufferAddress(Input))
            , Length(Env->GetDirectBufferCapacity(Input))
        {
        }

        const void* Data() const {
            return Start;
        }

        std::size_t Size() const {
            return static_cast<std::size_t>(Length);
        }

    private:
        JNIEnv* const Env;
        const jobject Input;
        void* const Start;
        const jlong Length;
    };
}
