#include "jni_launcher.h"
#include "jni_launcher_jni.h"
#include "jni_audio_sink.h"
#include "jni_exception.h"
#include "jni_data.h"
#include <yandex_io/android_sdk/libs/cpp/interfaces/launcher.h>
#include <yandex_io/scaffolding/proto/config.pb.h>

namespace {
    static NJni::TCheckedPtr<std::unique_ptr<YandexIO::ILauncher>> launcher;
}

namespace YandexIO {
    void setNativeLauncherInterface(std::unique_ptr<ILauncher> iface) {
        launcher = std::move(iface);
    }
}

JNIEXPORT void JNICALL Java_com_yandex_io_JniLauncher_initialize(JNIEnv* env, jobject, jbyteArray configSerialized) {
    NJni::Call(env, [env, configSerialized] {
        NJni::TByteArray input(env, configSerialized);
        auto config = std::make_shared<LauncherConfig>();
        NJni::Require(config->ParseFromArray(input.Data(), input.Size()), "Failed to parse protobuf config");
        launcher->initialize(std::move(config));
    });
}

JNIEXPORT void JNICALL Java_com_yandex_io_JniLauncher_setAudioSink(JNIEnv* env, jobject, jobject sink) {
    NJni::Call(env, [sink] {
        launcher->setAudioSink(YandexIO::createJavaAudioSink(sink));
    });
}

JNIEXPORT void JNICALL Java_com_yandex_io_JniLauncher_start(JNIEnv* env, jobject) {
    NJni::Call(env, [] {
        launcher->start();
    });
}
