#include "jni_voice_sink.h"
#include "jni_voice_sink_jni.h"
#include "jni_exception.h"
#include "jni_data.h"

#include <yandex_io/android_sdk/libs/cpp/interfaces/audio_sink.h>

namespace {
    static NJni::TCheckedPtr<std::shared_ptr<YandexIO::IAudioSink>> voiceSink;
}

namespace YandexIO {
    void setNativeVoiceSinkInterface(std::shared_ptr<IAudioSink> iface) {
        voiceSink = std::move(iface);
    }

    IAudioSink* getNativeVoiceSinkInterfaceForTest() {
        return voiceSink.Get();
    }
}

JNIEXPORT void JNICALL Java_com_yandex_io_JniVoiceSink_start(JNIEnv* env, jobject, jint channels, jint sampleRate, jint sampleSize) {
    NJni::Call(env, [=] {
        voiceSink->start(channels, sampleRate, sampleSize);
    });
}

JNIEXPORT void JNICALL Java_com_yandex_io_JniVoiceSink_pushData(JNIEnv* env, jobject, jobject data) {
    NJni::Call(env, [env, data] {
        const NJni::TByteBuffer buffer(env, NJni::RequireNotNull(data));
        voiceSink->pushData({static_cast<const uint8_t*>(buffer.Data()), buffer.Size()});
    });
}
