package com.yandex.io

import java.nio.ByteBuffer

// Java counterpart of quasar::IAudioSink
interface AudioSink {
    fun start(channels: Int, sampleRate: Int, sampleSize: Int)
    fun pause()
    fun resume()
    fun cancel()
    fun finish()

    /**
     * Note: data may be released after call, so should not be captured
     */
    fun pushData(data: ByteBuffer)
}
