package com.yandex.io;

import androidx.annotation.NonNull;

import java.nio.ByteBuffer;

/**
 * @apiNote Requires quasar::setNativeVoiceSinkInterface call before usage
 */
public class JniVoiceSink implements AudioSink {

    private JniVoiceSink() {}

    @Override
    public native void start(int channels, int sampleRate, int sampleSize);

    @Override
    public void pause() {}

    @Override
    public void resume() {}

    @Override
    public void cancel() {}

    @Override
    public void finish() {}

    @Override
    public native void pushData(@NonNull ByteBuffer data);

    public static AudioSink instance() {
        return Holder.INSTANCE;
    }

    private static class Holder {
        private static final AudioSink INSTANCE = new JniVoiceSink();
    }
}
