#include "create_private_chat_task.h"

#include <yandex_io/libs/base/utils.h>
#include <yandex_io/libs/json_utils/json_utils.h>
#include <yandex_io/libs/logging/logging.h>

YIO_DEFINE_LOG_MODULE("callkit");

using namespace messenger;

CreatePrivateChatTask::CreatePrivateChatTask(
    std::shared_ptr<SessionRequestFactory> requestFactory,
    const std::string& userGuid)
    : SessionApiTask(std::move(requestFactory))
    , userGuid_(userGuid)
{
}

CreatePrivateChatTask::~CreatePrivateChatTask() = default;

std::string CreatePrivateChatTask::getName() {
    return "CreatePrivateChatTask";
}

void CreatePrivateChatTask::prepare(SessionApiRequest* request) {
    request->setMethod("create_private_chat");
    Json::Value params;
    params["guid"] = userGuid_;
    request->setParams(params);
}

void CreatePrivateChatTask::onSuccess(Json::Value data) {
    auto user = quasar::tryGetJson(data, "user", Json::Value::null);
    auto chat = data["chat"];
    if (user.isNull() || chat.isNull()) {
        YIO_LOG_ERROR_EVENT("CreatePrivateChatTask.InvalidResponseData", "Invalid response data");
        onError(-1);
    } else {
        YIO_LOG_INFO("Chat created");
        onResponse(user, chat);
    }
}

void CreatePrivateChatTask::onError(int errorCode) {
    // TODO(polikarpov): implement expired token?
}

void CreatePrivateChatTask::onResponse(const Json::Value& userData,
                                       const Json::Value& chatData) {
}
