#pragma once

#include "session_api_request.h"
#include "session_api_task.h"

#include <json/value.h>

#include <string>

namespace messenger {

    class CreatePrivateChatTask: public SessionApiTask {
    public:
        CreatePrivateChatTask(std::shared_ptr<SessionRequestFactory> requestFactory,
                              const std::string& userGuid);
        ~CreatePrivateChatTask() override;

        std::string getName() override;
        void prepare(SessionApiRequest* request) override;
        void onSuccess(Json::Value data) final;
        void onError(int code) override;

    protected:
        virtual void onResponse(const Json::Value& userData,
                                const Json::Value& chatData);

    private:
        const std::string& userGuid_;
    };

} // namespace messenger
