#include "request_user_task.h"

#include <yandex_io/libs/base/utils.h>
#include <yandex_io/libs/json_utils/json_utils.h>

using namespace messenger;

RequestUserTask::RequestUserTask(
    std::shared_ptr<SessionRequestFactory> requestFactory,
    std::shared_ptr<DataStorage> dataStorage, bool requestXivaSecret)
    : SessionApiTask(std::move(requestFactory))
    , dataStorage_(std::move(dataStorage))
    , requestXivaSecret_(requestXivaSecret)
{
}

RequestUserTask::~RequestUserTask() {
}

std::string RequestUserTask::getName() {
    return "RequestUserTask";
}

void RequestUserTask::prepare(SessionApiRequest* request) {
    request->setMethod("request_user");
    if (requestXivaSecret_) {
        Json::Value params;
        params["get_secret_sign"] = true;
        request->setParams(params);
    }
}

void RequestUserTask::onSuccess(Json::Value data) {
    dataStorage_->setUser(data["user"]);
    auto xivaSecret =
        quasar::tryGetJson(data, "secret_sign", Json::Value::null);
    if (!xivaSecret.isNull() &&
        (quasar::tryGetString(xivaSecret, "ts", "").empty() ||
         quasar::tryGetString(xivaSecret, "sign", "").empty())) {
        xivaSecret = Json::Value::null;
    }
    dataStorage_->setXivaSecret(xivaSecret);
}

void RequestUserTask::onError(int errorCode) {
    // TODO(polikarpov): implement expired token?
}
