#pragma once

#include "session_api_request.h"
#include "session_api_task.h"

#include <yandex_io/callkit/storage/data_storage.h>

#include <json/value.h>

#include <string>

namespace messenger {

    class RequestUserTask: public SessionApiTask {
    public:
        RequestUserTask(std::shared_ptr<SessionRequestFactory> requestFactory,
                        std::shared_ptr<DataStorage> dataStorage,
                        bool requestXivaSecret);
        ~RequestUserTask() override;

        std::string getName() override;
        void prepare(SessionApiRequest* request) override;
        void onSuccess(Json::Value data) override;
        void onError(int code) override;

    private:
        std::shared_ptr<DataStorage> dataStorage_;
        bool requestXivaSecret_;
    };

} // namespace messenger
