#pragma once

#include <json/value.h>
#include <yandex_io/libs/http_client/http_client.h>

#include <map>
#include <memory>
#include <string>

namespace messenger {

    class SessionApiRequest {
    public:
        using OnExpiredTokenCallback = std::function<void()>;

        explicit SessionApiRequest(std::shared_ptr<quasar::HttpClient> client, OnExpiredTokenCallback callback);
        virtual ~SessionApiRequest();

        SessionApiRequest& addHeader(const std::string& name,
                                     const std::string& value);
        SessionApiRequest& setUrl(const std::string& url);
        SessionApiRequest& setMethod(const std::string& name);
        SessionApiRequest& setParams(const Json::Value& params);

        Json::Value getResult() const;
        int getErrorCode() const;

        std::string toCurlCmd() const;

        // call on web thread
        void executeSync();

    private:
        std::shared_ptr<quasar::HttpClient> client_;
        OnExpiredTokenCallback onExpiredTokenCallback_;
        std::map<std::string, std::string> headers_;
        std::string url_;
        Json::Value data_;
        Json::Value result_ = Json::Value::null;
        int resultCode_ = 0;
    };

} // namespace messenger
