#include "session_api_service.h"

#include "request_user_task.h"
#include "session_request_factory.h"

#include <yandex_io/callkit/session/session_settings.h>
#include <yandex_io/callkit/storage/data_storage.h>
#include <yandex_io/callkit/util/async_service.h>

#include <yandex_io/libs/device/i_device.h>
#include <yandex_io/libs/http_client/http_client.h>
#include <yandex_io/libs/logging/logging.h>

#include <algorithm>
#include <memory>
#include <utility>

using namespace messenger;

SessionApiService::SessionApiService(std::shared_ptr<LoopThread> workerThread,
                                     SessionRequestFactory::OnExpiredTokenCallback callback,
                                     std::shared_ptr<DataStorage> dataStorage,
                                     const SessionSettings& settings,
                                     std::shared_ptr<YandexIO::IDevice> device)
    : dataStorage_(std::move(dataStorage))
{
    requestFactory_ = std::make_shared<SessionRequestFactory>(
        std::make_shared<quasar::HttpClient>("messenger", std::move(device)), settings, std::move(callback));
    taskExecutor_ = std::make_unique<AsyncService>(
        std::move(workerThread));
}

SessionApiService::~SessionApiService() {
    YIO_LOG_INFO("SessionApiService destroy");
}

void SessionApiService::requestUser(bool requestXivaSecret) {
    auto task = std::make_shared<RequestUserTask>(requestFactory_, dataStorage_,
                                                  requestXivaSecret);
    taskExecutor_->start(task);
}

bool SessionApiService::hasTasks() {
    return taskExecutor_->hasTasks();
}

void SessionApiService::runOnIdle(std::function<void()> callback) {
    taskExecutor_->runOnIdle(std::move(callback));
}

std::shared_ptr<SessionRequestFactory>
SessionApiService::getRequestFactory() const {
    return requestFactory_;
}

std::shared_ptr<AsyncService> SessionApiService::getTaskExecutor() const {
    return taskExecutor_;
}
