#pragma once

#include "session_request_factory.h"

#include <functional>
#include <memory>
#include <queue>
#include <vector>

namespace YandexIO {
    class IDevice;
} // namespace YandexIO

namespace messenger {

    class LoopThread;
    class SessionRequestFactory;
    class AsyncService;
    class DataStorage;
    struct SessionSettings;

    // on: worker
    class SessionApiService {
    public:
        SessionApiService(std::shared_ptr<LoopThread> workerThread,
                          SessionRequestFactory::OnExpiredTokenCallback callback,
                          std::shared_ptr<DataStorage> dataStorage,
                          const SessionSettings& settings,
                          std::shared_ptr<YandexIO::IDevice> device);
        virtual ~SessionApiService();

        void requestUser(bool requestXivaSecret);

        bool hasTasks();
        void runOnIdle(std::function<void()> callback);

        std::shared_ptr<SessionRequestFactory> getRequestFactory() const;
        std::shared_ptr<AsyncService> getTaskExecutor() const;

    private:
        std::shared_ptr<DataStorage> dataStorage_;
        std::shared_ptr<SessionRequestFactory> requestFactory_;
        std::shared_ptr<AsyncService> taskExecutor_;
    };

} // namespace messenger
