#include "session_api_task.h"

#include <yandex_io/libs/base/utils.h>
#include <yandex_io/libs/json_utils/json_utils.h>

using namespace messenger;

SessionApiTask::SessionApiTask(
    std::shared_ptr<SessionRequestFactory> requestFactory)
    : request_(requestFactory->createRequest())
{
}

SessionApiTask::~SessionApiTask() {
}

void SessionApiTask::prepare(SessionApiRequest* request) {
}

void SessionApiTask::run() {
    pthread_setname_np(pthread_self(), getName().c_str());
    request_->addHeader("X-Request-Id", quasar::makeUUID());
    prepare(request_.get());
    request_->executeSync();
}

void SessionApiTask::onFinished() {
    const int errCode = request_->getErrorCode();
    const auto result = request_->getResult();
    const auto status = quasar::tryGetString(result, "status", "error");

    if (errCode == 200 && status == "ok") {
        const auto data = quasar::tryGetJson(result, "data", Json::Value::null);
        onSuccess(data);
        return;
    }

    onError(errCode);
}
