#pragma once

#include "session_api_request.h"
#include "session_request_factory.h"

#include <yandex_io/callkit/util/async_task.h>

#include <memory>

namespace messenger {

    class SessionApiTask: public AsyncTask {
    public:
        SessionApiTask(std::shared_ptr<SessionRequestFactory> requestFactory);
        virtual ~SessionApiTask();

    private:
        // on: bg
        void run() final;
        std::string getName() override = 0;
        // on: worker thread
        void onFinished() override;

        // on: bg
        virtual void prepare(SessionApiRequest* request);
        // on: worker thread
        virtual void onSuccess(Json::Value response) = 0;
        // on: worker thread
        virtual void onError(int code) = 0;

        std::unique_ptr<SessionApiRequest> request_;
    };

} // namespace messenger
