#include "session_request_factory.h"

#include "session_api_request.h"

#include <yandex_io/callkit/session/session_settings.h>

#include <yandex_io/libs/http_client/http_client.h>

using namespace messenger;

SessionRequestFactory::SessionRequestFactory(
    std::shared_ptr<quasar::HttpClient> client, const SessionSettings& settings, OnExpiredTokenCallback callback)
    : client_(std::move(client))
    , onExpiredTokenCallback_(std::move(callback))
    , sessionId_(settings.sessionId)
    , authHeader_("OAuth " + settings.params.token)
    , host_(settings.params.messengerApiHost)
    , url_("https://" + host_ + "/api/")
{
    client_->setTimeout(std::chrono::milliseconds{5000});
    client_->setRetriesCount(3);
}

SessionRequestFactory::~SessionRequestFactory() = default;

std::unique_ptr<SessionApiRequest> SessionRequestFactory::createRequest() {
    auto* request = new SessionApiRequest(client_, onExpiredTokenCallback_);
    request->addHeader("Authorization", authHeader_);
    request->addHeader("X-Session-Id", sessionId_);
    request->addHeader("Connection", "Keep-Alive");
    request->addHeader("Host", host_);
    request->addHeader("Content-Type", "application/json");
    request->addHeader("X-VERSION", "2");
    request->setUrl(url_);
    return std::unique_ptr<SessionApiRequest>(request);
}
