#pragma once

#include <yandex_io/libs/http_client/http_client.h>

#include <functional>
#include <memory>
#include <queue>
#include <string>
#include <vector>

namespace messenger {

    struct SessionSettings;
    class SessionApiRequest;

    class SessionRequestFactory {
    public:
        using OnExpiredTokenCallback = std::function<void()>;

        SessionRequestFactory(std::shared_ptr<quasar::HttpClient> client,
                              const SessionSettings& settings,
                              OnExpiredTokenCallback callback);
        virtual ~SessionRequestFactory();

        std::unique_ptr<SessionApiRequest> createRequest();

    private:
        std::shared_ptr<quasar::HttpClient> client_;
        OnExpiredTokenCallback onExpiredTokenCallback_;
        std::string sessionId_;
        std::string authHeader_;
        std::string host_;
        std::string url_;
    };

} // namespace messenger
