#pragma once

#include "notifier.h"
#include "status.h"
#include "statemachine/call_state_machine.h"
#include "statemachine/user_action_dispatcher.h"

#include <yandex_io/callkit/calls/calls_controller.h>
#include <yandex_io/callkit/rtc/media/direction.h>
#include <yandex_io/callkit/util/weak_utils.h>

#include <memory>
#include <string>

namespace messenger {

    class CallsController;
    class CallTransport;
    class LoopThread;

    namespace rtc {
        class MediaSession;
    } // namespace rtc

    // on: worker thread
    class Call: public std::enable_shared_from_this<Call> {
        CREATE_FROM_INIT(Call);

    public:
        virtual ~Call();

        void start();
        void stop();
        void answer();
        void decline();

        std::string getChatId() const;
        std::string getUserName() const;
        std::string getUserAvatar() const;
        std::string getUserGuid() const;
        std::string getCallGuid() const;
        std::string getCallerDeviceId() const;
        std::string getCallerPayload() const;
        rtc::Direction getDirection() const;
        std::weak_ptr<CallsController> getCallsController() const;
        Status getStatus() const;
        rtc::MediaSession* getMediaSession() const;

        bool setUserName(const std::string& value);
        bool setUserAvatar(const std::string& value);

        std::shared_ptr<Notifier> notifier;

    private:
        void init(const std::string& chatId, const std::string& userName, const std::string& userAvatar,
                  const std::string& userGuid, const std::string& callerDeviceId, const std::string& callerPayload,
                  rtc::Direction direction,
                  std::weak_ptr<CallsController> callsController,
                  std::shared_ptr<rtc::MediaSession> mediaSession,
                  std::shared_ptr<LoopThread> workerThread,
                  std::shared_ptr<CallTransport> callTransport);

        std::string chatId_;
        std::string userName_;
        std::string userAvatar_;
        std::string userGuid_;
        std::string callerDeviceId_;
        std::string callerPayload_;
        rtc::Direction direction_;
        std::weak_ptr<CallsController> callsController_;
        std::shared_ptr<rtc::MediaSession> mediaSession_;
        std::shared_ptr<LoopThread> workerThread_;
        std::shared_ptr<UserActionDispatcher> userActionDispatcher_;
        std::shared_ptr<CallStateMachine> machine_;
        std::shared_ptr<CallTransport> callTransport_;
    };

} // namespace messenger
