#include "call_holder.h"

#include "call.h"

#include <yandex_io/callkit/util/loop_thread.h>

using namespace messenger;

CallHolder::CallHolder(std::shared_ptr<LoopThread> workerThread)
    : workerThread_(std::move(workerThread))
{
}

CallHolder::~CallHolder() = default;

void CallHolder::setCall(std::shared_ptr<Call> call) {
    Y_VERIFY(workerThread_->checkInside());
    call_ = call;
    YIO_LOG_DEBUG("Call switched to " << (call_ ? call_->getChatId() : "null"));
    onCallChanged.notifyObservers(call_);
}

std::shared_ptr<Call> CallHolder::getCall() {
    Y_VERIFY(workerThread_->checkInside());
    return call_;
}
