#pragma once

#include "call_transport.h"

#include <yandex_io/callkit/util/observer_list.h>

namespace messenger {

    class Call;
    class LoopThread;

    // on: worker thread
    class CallHolder {
    public:
        CallHolder(std::shared_ptr<LoopThread> workerThread);
        virtual ~CallHolder();

        void setCall(std::shared_ptr<Call> call);
        std::shared_ptr<Call> getCall();

        using CallSubscription =
            ObserverList<std::shared_ptr<Call>>::ScopedSubscription;
        using CallFailedSubscription =
            ObserverList<const std::string&>::ScopedSubscription;

        ObserverList<std::shared_ptr<Call>> onCallChanged;
        // We have this observers here since Notifier exists only with a created
        // call.
        using CallCreationFailedObserverList =
            ObserverList<const std::string& /*userguid*/, CallTransport::ErrorCode>;
        using CallCreationFailedSubscription =
            CallCreationFailedObserverList::ScopedSubscription;
        ObserverList<const std::string& /*userguid*/, CallTransport::ErrorCode>
            onCallCreationFailed;

    private:
        std::shared_ptr<LoopThread> workerThread_;
        std::shared_ptr<Call> call_;
    };

} // namespace messenger
