#include "call_transport.h"

using namespace messenger;

namespace {
    const char* ERROR_TEXTS[] = {
        "BAD_REQUEST",
        "CONFLICT",
        "BLOCKED_BY_PRIVACY_SETTINGS",
        "TIMEOUT",
        "UNKNOWN",
    };
} // namespace

static_assert((unsigned)CallTransport::ErrorCode::LAST_VALUE ==
              sizeof(ERROR_TEXTS) / sizeof(char*));

CallTransport::CallTransport()
    : listeners(new Listeners())
{
}

CallTransport::~CallTransport() = default;

// static
const char* CallTransport::toString(ErrorCode errorCode) {
    return ERROR_TEXTS[(unsigned)errorCode];
}
