#pragma once

#include "request_id.h"

#include <yandex_io/callkit/util/observer_list.h>

#include <memory>
#include <string>

namespace messenger {

    namespace rtc {
        class DeviceInfo;
    } // namespace rtc

    class CallTransport {
    public:
        enum class ErrorCode {
            /* incoming call errors */
            BAD_REQUEST,
            CONFLICT,

            /* outgoing call errors */
            BLOCKED_BY_PRIVACY_SETTINGS,
            TIMEOUT,

            /* common */
            UNKNOWN,

            LAST_VALUE,
        };
        static const char* toString(ErrorCode errorCode);

        CallTransport();
        virtual ~CallTransport();

        virtual RequestId makeCall(std::shared_ptr<rtc::DeviceInfo> deviceInfo) = 0;
        virtual RequestId
        acceptCall(std::shared_ptr<rtc::DeviceInfo> deviceInfo) = 0;
        virtual RequestId declineCall() = 0;

        virtual RequestId endCall() = 0;
        virtual RequestId notifyRinging() = 0;
        virtual void dispose() = 0;

        using OnAckReceived = ObserverList<RequestId>;
        using OnErrorReceived = ObserverList<RequestId, ErrorCode>;
        using OnCallAccepted = ObserverList<>;
        using OnCallAcceptedByOtherClient = ObserverList<>;
        using OnCallDeclined = ObserverList<>;
        using OnCallEnded = ObserverList<>;
        using OnRinging = ObserverList<>;
        using AckReceivedSubscription = OnAckReceived::ScopedSubscription;
        using ErrorReceivedSubscription = OnErrorReceived::ScopedSubscription;
        using CallAcceptedSubscription = OnCallAccepted::ScopedSubscription;
        using CallAcceptedByOtherClientSubscription =
            OnCallAcceptedByOtherClient::ScopedSubscription;
        using CallDeclinedSubscription = OnCallDeclined::ScopedSubscription;
        using CallEndedSubscription = OnCallEnded::ScopedSubscription;
        using RingingSubscription = OnRinging::ScopedSubscription;

        struct Listeners {
            OnAckReceived onAckReceived;
            OnErrorReceived onErrorReceived;
            OnCallAccepted onCallAccepted;
            OnCallAcceptedByOtherClient onCallAcceptedByOtherClient;
            OnCallDeclined onCallDeclined;
            OnCallEnded onCallEnded;
            OnRinging onRinging;

            Listeners() = default;
            virtual ~Listeners() = default;
        };

        const std::shared_ptr<Listeners> listeners;
    };

} // namespace messenger
