#pragma once

#include "call_transport.h"

#include <yandex_io/callkit/rtc/media/media_session.h>
#include <yandex_io/callkit/util/observer_list.h>

#include <memory>
#include <string>

namespace messenger {

    namespace rtc {
        class MediaSession;
    } // namespace rtc

    class Call;

    class Notifier: public std::enable_shared_from_this<Notifier> {
    public:
        Notifier(std::weak_ptr<Call> call);
        virtual ~Notifier();
        void attachMediaSessionCallbacks(rtc::MediaSession* mediaSession);

        using CallbackList = ObserverList<const std::string& /*chatId*/>;
        using FailureCallbackList =
            ObserverList<const std::string& /*chatId*/, CallTransport::ErrorCode,
                         const std::string& /*message*/>;

        using OnStartListener = CallbackList::ObserverType;
        using OnStartSubscription = CallbackList::ScopedSubscription;
        using OnEndListener = CallbackList::ObserverType;
        using OnEndSubscription = CallbackList::ScopedSubscription;
        using OnStatusChangeListener = CallbackList::ObserverType;
        using OnStatusChangeSubscription = CallbackList::ScopedSubscription;
        using OnAcceptListener = CallbackList::ObserverType;
        using OnAcceptSubscription = CallbackList::ScopedSubscription;
        using OnDeclineListener = CallbackList::ObserverType;
        using OnDeclineSubscription = CallbackList::ScopedSubscription;
        using OnFailureListener = FailureCallbackList ::ObserverType;
        using OnFailureSubscription = FailureCallbackList::ScopedSubscription;

        [[nodiscard]] OnStartSubscription
        subscribeOnStart(OnStartListener listener);
        [[nodiscard]] OnEndSubscription subscribeOnEnd(OnEndListener listener);
        [[nodiscard]] OnAcceptSubscription
        subscribeOnAccept(OnAcceptListener listener);
        [[nodiscard]] OnDeclineSubscription
        subscribeOnDecline(OnDeclineListener listener);
        [[nodiscard]] OnFailureSubscription
        subscribeOnFailure(OnFailureListener listener);

        void notifyEnd();
        void notifyStart();
        void notifyStatusChange();
        void notifyAccept();
        void notifyDecline();
        void notifyFailure(CallTransport::ErrorCode code,
                           const std::string& message = "");

        CallbackList onStatusChangeListeners;

    private:
        std::weak_ptr<Call> call_;

        ObserverList<const std::string& /*chatId*/> onStartListeners_;
        ObserverList<const std::string& /*chatId*/> onEndListeners_;
        ObserverList<const std::string& /*chatId*/> onAcceptListeners_;
        ObserverList<const std::string& /*chatId*/> onDeclineListeners_;
        ObserverList<const std::string& /*chatId*/, CallTransport::ErrorCode,
                     const std::string& /*message*/>
            onFailureListeners_;

        rtc::MediaSession::StatusSubscription statusChangeSubscription_;
        rtc::MediaSession::FailureSubscription failureSubscription_;
    };

} // namespace messenger
