#include "request_id.h"

#include <yandex_io/libs/base/utils.h>

#include <util/system/yassert.h>

using namespace messenger;

RequestId::RequestId(const std::string& id)
    : id_(id)
{
    Y_VERIFY(!id.empty());
    Y_VERIFY(quasar::isUUID(id));
}

RequestId::RequestId()
{
}

// static
RequestId RequestId::generate() {
    return RequestId(quasar::makeUUID());
}

// static
RequestId RequestId::null() {
    return RequestId();
}

RequestId::operator bool() const {
    return !id_.empty();
}

bool RequestId::operator==(const RequestId& other) const {
    return id_ == other.id_;
}

bool RequestId::operator!=(const RequestId& other) const {
    return id_ != other.id_;
}

std::string RequestId::getId() const {
    return id_;
}
