#pragma once

#include <string>

namespace messenger {

    struct RequestId {
        RequestId();
        explicit RequestId(const std::string& id);
        RequestId(const RequestId& other) = default;

        static RequestId generate();
        static RequestId null();

        explicit operator bool() const;
        bool operator==(const RequestId& other) const;
        bool operator!=(const RequestId& other) const;
        std::string getId() const;

    private:
        std::string id_;
    };

} // namespace messenger
