#include "call_ending_state.h"

#include "call_ended_state.h"
#include "call_state_machine.h"

#include <yandex_io/callkit/calls/call/call_transport.h>
#include <yandex_io/callkit/calls/call/notifier.h>
#include <yandex_io/callkit/calls/call/status.h>

#include <yandex_io/callkit/rtc/media/media_session.h>

using namespace messenger;

CallEndingState::CallEndingState(bool sendEndCall)
    : sendEndCall_(sendEndCall)
{
}

CallEndingState::~CallEndingState() = default;

void CallEndingState::enter(CallStateMachine* machine) {
    if (sendEndCall_) {
        // We should dispose call immediately, ack may not be delivered in
        // bad network conditions
        machine->getTransport()->endCall();
    }
    machine->getMediaSession()->dispose();
    machine->getTransport()->dispose();

    machine->setCallStatus(Status::ENDED);
    machine->getNotifier()->notifyStatusChange();
    machine->getNotifier()->notifyEnd();

    machine->setState(std::make_shared<CallEndedState>());
}

void CallEndingState::exit() {
}

std::string CallEndingState::toString() const {
    return "CallEndingState";
}
