#pragma once

#include "call_state.h"

#include <yandex_io/callkit/calls/call/call_transport.h>

#include <yandex_io/callkit/rtc/media/media_session.h>
#include <yandex_io/callkit/util/loop_thread.h>
#include <yandex_io/callkit/util/observer_list.h>

#include <memory>

namespace messenger {

    class CallStateMachine;

    class CallLiveState: public CallState,
                         public std::enable_shared_from_this<CallLiveState> {
    public:
        CallLiveState();
        ~CallLiveState();

        void enter(CallStateMachine* machine) override;
        void exit() override;

        std::string toString() const override;

    private:
        void startTimeoutTimer(CallStateMachine* machine);
        void stopTimeoutTimer();

        CallbackSubscription stopCallSubscription_;
        CallbackSubscription acceptOrStopCallSubscription_;
        CallTransport::CallAcceptedSubscription callEndedSubscription_;
        rtc::MediaSession::StatusSubscription statusChangeSubscription_;
        ScopedExecutor timoutExecutor_;
    };

} // namespace messenger
