#include "call_start_awaiting_state.h"

#include "incoming_call_ringing_state.h"
#include "outgoing_call_creating_state.h"
#include "user_action_dispatcher.h"

using namespace messenger;

CallStartAwaitingState::CallStartAwaitingState() {
}

CallStartAwaitingState::~CallStartAwaitingState() = default;

void CallStartAwaitingState::enter(CallStateMachine* machine) {
    outgoingCallSubscription_ =
        machine->actions->onStartOutgoingCall.subscribe(machine, [machine] {
            machine->setState(std::make_shared<OutgoingCallCreatingState>());
        });
    incomingCallSubscription_ =
        machine->actions->onStartIncomingCall.subscribe(machine, [machine] {
            machine->setState(std::make_shared<IncomingCallRingingState>());
        });
}

void CallStartAwaitingState::exit() {
    outgoingCallSubscription_.reset();
}

std::string CallStartAwaitingState::toString() const {
    return "CallStartAwaitingState";
}
