#pragma once

#include <yandex_io/callkit/calls/call/status.h>

#include <yandex_io/callkit/rtc/media/device_info.h>
#include <yandex_io/callkit/rtc/media/direction.h>
#include <yandex_io/callkit/util/weak_utils.h>

#include <chrono>
#include <memory>
#include <string>

namespace messenger {

    class CallState;
    class CallTransport;
    class LoopThread;
    class Notifier;
    struct UserActionDispatcher;

    namespace rtc {
        class MediaSession;
    } // namespace rtc

    class CallStateMachine: public std::enable_shared_from_this<CallStateMachine> {
        CREATE_FROM_INIT(CallStateMachine);

    public:
        virtual ~CallStateMachine();

        rtc::Direction getDirection();
        Status getCallStatus();
        std::string getCallUuid();
        void setCallStatus(Status status);
        std::shared_ptr<rtc::DeviceInfo> createDeviceInfo();

        std::shared_ptr<UserActionDispatcher> actions;

    protected:
        friend class CallEndingState;
        friend class CallLiveState;
        friend class CallStartAwaitingState;
        friend class IncomingCallAcceptingState;
        friend class IncomingCallDeclinedState;
        friend class IncomingCallDecliningState;
        friend class IncomingCallRingingState;
        friend class InitialCallState;
        friend class OutgoingCallAcceptAwaitingState;
        friend class OutgoingCallCreatingState;
        friend class OutgoingCallCreationFailedState;

        void setState(std::shared_ptr<CallState> /*newState*/);
        void setStartDatetime(std::chrono::system_clock::time_point startDatetime);

        CallTransport* getTransport();
        rtc::MediaSession* getMediaSession();
        Notifier* getNotifier();
        LoopThread* getWorkerThread();

    private:
        void init(const std::string& callUuid,
                  std::shared_ptr<CallTransport> transport, rtc::Direction direction,
                  std::shared_ptr<rtc::MediaSession> mediaSession,
                  std::shared_ptr<LoopThread> workerThread,
                  std::shared_ptr<Notifier> notifier, Status status,
                  std::shared_ptr<UserActionDispatcher> userActionDispatcher);

        std::shared_ptr<CallState> state_;

        std::string callUuid_;
        rtc::Direction direction_;
        std::shared_ptr<CallTransport> transport_;
        std::shared_ptr<rtc::MediaSession> mediaSession_;
        std::shared_ptr<LoopThread> workerThread_;
        std::shared_ptr<Notifier> notifier_;
        Status callStatus_;
        std::shared_ptr<const rtc::DeviceInfo> deviceInfo_;
        std::chrono::system_clock::time_point startDatetime_;
    };

} // namespace messenger
