#pragma once

#include "call_state.h"

#include <yandex_io/callkit/calls/call/call_transport.h>

#include <yandex_io/callkit/util/loop_thread.h>
#include <yandex_io/callkit/xiva/request.h>

#include <memory>

namespace messenger {

    class CallStateMachine;

    class IncomingCallAcceptingState
        : public CallState,
          public std::enable_shared_from_this<IncomingCallAcceptingState> {
    public:
        IncomingCallAcceptingState();
        ~IncomingCallAcceptingState();

        void enter(CallStateMachine* machine) override;
        void exit() override;

        std::string toString() const override;

    private:
        void acceptCall(CallStateMachine* machine);

        RequestId requestId_;

        CallTransport::AckReceivedSubscription ackReceivedSubscription_;
        CallTransport::ErrorReceivedSubscription errorReceivedSubscription_;
        ScopedExecutor timoutExecutor_;
    };

} // namespace messenger
