#include "incoming_call_declined_state.h"

#include "call_ending_state.h"
#include "call_state_machine.h"

#include <yandex_io/callkit/calls/call/notifier.h>

using namespace messenger;

IncomingCallDeclinedState::IncomingCallDeclinedState() {
}

IncomingCallDeclinedState::~IncomingCallDeclinedState() = default;

void IncomingCallDeclinedState::enter(CallStateMachine* machine) {
    machine->getNotifier()->notifyDecline();
    machine->setState(std::make_shared<CallEndingState>(false));
}

void IncomingCallDeclinedState::exit() {
}

std::string IncomingCallDeclinedState::toString() const {
    return "IncomingCallDeclinedState";
}
