#include "incoming_call_declining_state.h"

#include "call_state_machine.h"
#include "incoming_call_declined_state.h"

#include <yandex_io/callkit/calls/call/call_transport.h>

using namespace messenger;

IncomingCallDecliningState::IncomingCallDecliningState() {
}

IncomingCallDecliningState::~IncomingCallDecliningState() = default;

void IncomingCallDecliningState::enter(CallStateMachine* machine) {
    machine->getTransport()->declineCall();
    // We should not wait for decline acknowledge, this can cause stuck of
    // the call in bad network conditions If decline request will not be
    // delivered we don't care, user don't want this call.
    machine->setState(std::make_shared<IncomingCallDeclinedState>());
}

void IncomingCallDecliningState::exit() {
}

std::string IncomingCallDecliningState::toString() const {
    return "IncomingCallDecliningState";
}
