#pragma once

#include "call_state.h"

#include <yandex_io/callkit/calls/call/call_transport.h>
#include <yandex_io/callkit/calls/call/request_id.h>

#include <yandex_io/callkit/util/loop_thread.h>
#include <yandex_io/callkit/util/observer_list.h>

#include <memory>

namespace messenger {

    class CallStateMachine;

    class IncomingCallRingingState
        : public CallState,
          public std::enable_shared_from_this<IncomingCallRingingState> {
    public:
        IncomingCallRingingState();
        ~IncomingCallRingingState();

        void enter(CallStateMachine* machine) override;
        void exit() override;

        std::string toString() const override;

    private:
        RequestId requestId_;

        CallbackSubscription acceptCallSubscription_;
        CallbackSubscription declineCallSubscription_;
        CallbackSubscription stopCallSubscription_;
        CallbackSubscription acceptOrStopCallSubscription_;

        CallTransport::CallAcceptedByOtherClientSubscription
            acceptedByOtherSubscription_;
        CallTransport::CallEndedSubscription endedSubscription_;
        CallTransport::CallDeclinedSubscription declinedSubscription_;
        CallTransport::AckReceivedSubscription ackReceivedSubscription_;
        CallTransport::ErrorReceivedSubscription errorReceivedSubscription_;

        ScopedExecutor timoutExecutor_;
    };

} // namespace messenger
