#pragma once

#include "call_state.h"

#include <yandex_io/callkit/calls/call/call_transport.h>

#include <yandex_io/callkit/util/loop_thread.h>
#include <yandex_io/callkit/util/observer_list.h>

#include <memory>

namespace messenger {

    class CallStateMachine;

    class OutgoingCallAcceptAwaitingState
        : public CallState,
          public std::enable_shared_from_this<OutgoingCallAcceptAwaitingState> {
    public:
        OutgoingCallAcceptAwaitingState();
        ~OutgoingCallAcceptAwaitingState();

        void enter(CallStateMachine* machine) override;
        void exit() override;

        std::string toString() const override;

    private:
        CallbackSubscription onStopCallSubscription_;
        CallTransport::CallAcceptedSubscription callAcceptedSubscription_;
        CallTransport::CallAcceptedByOtherClientSubscription
            callOtherAcceptedSubscription_;
        CallTransport::CallDeclinedSubscription callDeclinedSubscription_;
        CallTransport::RingingSubscription ringingSubscription_;

        ScopedExecutor timeoutCallbackRunner_;
    };

} // namespace messenger
