#pragma once

#include "call_state.h"

#include <yandex_io/callkit/calls/call/call_transport.h>
#include <yandex_io/callkit/calls/call/request_id.h>

#include <yandex_io/callkit/util/loop_thread.h>
#include <yandex_io/callkit/util/observer_list.h>

#include <memory>

namespace messenger {

    class CallStateMachine;

    class OutgoingCallCreatingState
        : public CallState,
          public std::enable_shared_from_this<OutgoingCallCreatingState> {
    public:
        OutgoingCallCreatingState();
        ~OutgoingCallCreatingState();

        void enter(CallStateMachine* machine) override;
        void exit() override;

        std::string toString() const override;

    private:
        void makeCall(CallStateMachine* machine);

        RequestId requestId_;

        CallbackSubscription onStopCallSubscription_;
        CallTransport::AckReceivedSubscription ackSubscription_;
        CallTransport::ErrorReceivedSubscription errorSubscription_;

        ScopedExecutor timoutExecutor_;
    };

} // namespace messenger
