#include "outgoing_call_creation_failed_state.h"

#include "call_ending_state.h"
#include "call_state_machine.h"

#include <yandex_io/callkit/calls/call/notifier.h>

#include <yandex_io/libs/logging/logging.h>

using namespace messenger;

OutgoingCallCreationFailedState::OutgoingCallCreationFailedState(
    CallTransport::ErrorCode errorCode)
    : errorCode_(errorCode)
{
}

OutgoingCallCreationFailedState::~OutgoingCallCreationFailedState() = default;

void OutgoingCallCreationFailedState::enter(CallStateMachine* machine) {
    YIO_LOG_INFO("Failed to create outgoing call: "
                 << CallTransport::toString(errorCode_));
    machine->getNotifier()->notifyFailure(errorCode_,
                                          CallTransport::toString(errorCode_));
    machine->setState(std::make_shared<CallEndingState>(false));
}

void OutgoingCallCreationFailedState::exit() {
}

std::string OutgoingCallCreationFailedState::toString() const {
    return "OutgoingCallCreationFailedState";
}
