#include "status.h"

#include <stdexcept>

namespace {
    const char* NAMES[] = {
        "NEW",
        "DIALING",
        "RINGING",
        "ACCEPTING",
        "CONNECTING",
        "CONNECTED",
        "ENDED",
        "NOCALL",
    };
} // namespace

using namespace messenger;

const char* messenger::toString(Status status) {
    return NAMES[(int)status];
}

Status messenger::fromString(const std::string& value) {
    for (unsigned i = 0u; i < sizeof(NAMES) / sizeof(*NAMES); i++) {
        if (value == NAMES[i]) {
            return static_cast<Status>(i);
        }
    }
    throw std::runtime_error("Call  Status '" + value + " not found");
}

bool messenger::operator<(Status left, Status right) {
    return static_cast<unsigned>(left) < static_cast<unsigned>(right);
}
