#pragma once

#include <string>

namespace messenger {

    enum class Status {
        /**
         * Call just created.
         */
        NEW,

        /**
         * Outgoing call: backend trying to wake up remote side.
         * Incoming call: never appears, not applicable.
         */
        DIALING,

        /**
         * Outgoing call: remote side device waked up and ringing.
         * Incoming call: this device is ringing.
         */
        RINGING,

        /**
         * Outgoing call: never appears, not applicable.
         * Incoming call: this device is accepting the call.
         */
        ACCEPTING,

        /**
         * Callee accepted the call, so both sides have consent to have media
         * exchange. But connection for media exchange not yet established.
         */
        CONNECTING,

        /**
         * Media exchange connection is established.
         */
        CONNECTED,

        /**
         * Call just ended.
         */
        ENDED,

        /**
         * Never started or ended.
         */
        NOCALL,
    };

    const char* toString(Status status);
    Status fromString(const std::string& value);
    bool operator<(Status left, Status right);

} // namespace messenger
