#pragma once

#include "call/call_transport.h"

#include <yandex_io/callkit/calls/types.h>
#include <yandex_io/callkit/rtc/media/transport.h>
#include <yandex_io/callkit/util/loop_thread.h>

#include <cstdint>
#include <map>
#include <memory>
#include <string>

namespace messenger {

    class LoopThread;

    // on: worker thread
    class CallingMessageReceiver {
    public:
        CallingMessageReceiver(std::shared_ptr<CallTransport::Listeners> listeners,
                               std::shared_ptr<LoopThread> workerThread,
                               const std::string& deviceId,
                               uint64_t receiverSequenceNumber);
        virtual ~CallingMessageReceiver();

        void dispose();

        void setCallGuid(const std::string& callGuid);
        void
        setMediaTransportListener(std::weak_ptr<rtc::Transport::Listener> listener);
        std::weak_ptr<rtc::Transport::Listener> getMediaTransportListener();
        void onCallingMessage(proto::CallingMessage message);

    private:
        void handleCallingMessage(proto::CallingMessage message);
        void handleMessageQueue();
        void startTimer();
        void stopTimer();
        void onTimeout();

        void handleTransportMessage(const std::string& transportMessagePayload);
        void handleCallAcceptedMessage(const std::string& acceptedDeviceId);

        std::shared_ptr<CallTransport::Listeners> callTransportListeners_;
        std::shared_ptr<LoopThread> workerThread_;
        ScopedExecutor timerExecutor_;
        std::string deviceId_;
        std::string callGuid_;
        std::weak_ptr<rtc::Transport::Listener> mediaTransportListener_;

        uint64_t expectedSequenceNumber_;
        std::map<uint64_t, proto::CallingMessage> queue_;
    };

} // namespace messenger
