#pragma once

#include <yandex_io/callkit/connection/push_handler.h>
#include <yandex_io/callkit/calls/types.h>
#include <yandex_io/callkit/util/cancelable.h>
#include <yandex_io/callkit/util/observer_list.h>
#include <yandex_io/callkit/util/weak_utils.h>

#include <memory>
#include <string>

namespace messenger {

    class LoopThread;
    class PushHandler;
    class RequestHandler;

    // on: worker thread
    class CallingMessagesSender
        : public std::enable_shared_from_this<CallingMessagesSender> {
        CREATE_FROM_INIT(CallingMessagesSender);

    public:
        [[nodiscard]] Cancelable sendCallingMessage(const std::string& payloadId,
                                                    proto::CallingMessage message);

        using OnCallingMessage = ObserverList<proto::CallingMessage, proto::ServerMessage>;
        using OnAckReceived = ObserverList<const std::string&>;
        using OnErrorReceived =
            ObserverList<const std::string&, proto::PostMessageResponse>;

        using CallingMessageSubscription = OnCallingMessage::ScopedSubscription;
        using AckReceivedSubscription = OnAckReceived::ScopedSubscription;
        using ErrorReceivedSubscription = OnErrorReceived::ScopedSubscription;

        OnCallingMessage onCallingMessage;
        OnAckReceived onAckReceived;
        OnErrorReceived onErrorReceived;

    private:
        void init(std::shared_ptr<LoopThread> workerThread,
                  std::shared_ptr<RequestHandler> requestHandler,
                  std::shared_ptr<PushHandler> pushHandler);
        void onServerMessage(proto::ServerMessage message);

        std::shared_ptr<LoopThread> workerThread_;
        std::shared_ptr<RequestHandler> requestHandler_;
        std::shared_ptr<PushHandler> pushHandler_;
        PushHandler::Subscription pushSubscription_;
    };

} // namespace messenger
