#pragma once

#include "call/call_holder.h"
#include "call/status.h"

#include <yandex_io/callkit/util/weak_utils.h>

#include <yandex_io/libs/ipc/i_ipc_factory.h>

#include <json/json.h>

#include <functional>
#include <memory>
#include <queue>

namespace messenger {

    class AsyncService;
    class CallHolder;
    class CallingMessagesSender;
    class CallsControllerProvider;
    class DataStorage;
    class LoopThread;
    class PushHandler;
    class RequestHandler;
    class SessionRequestFactory;
    struct SessionSettings;

    // on: worker thread
    class CallingService: public std::enable_shared_from_this<CallingService> {
        CREATE_FROM_INIT(CallingService);

    public:
        virtual ~CallingService();

        void setAllowUsualCalls(bool allowUsualCalls);
        std::shared_ptr<CallHolder> getCallHolder();
        void startCall(const std::string& userGuid, const std::string& callPayload);
        void startCallToOwnDevice(const std::string& deviceId, const std::string& callPayloads);
        void declineIncomingCall();
        void acceptIncomingCall();
        void hangupCall();

        bool hasBgTasks() const;
        void runOnBgIdle(std::function<void()> callback);

    private:
        friend class Session;

        void init(const std::shared_ptr<quasar::ipc::IIpcFactory>& ipcFactory,
                  const SessionSettings& settings,
                  std::shared_ptr<LoopThread> workerThread,
                  std::shared_ptr<DataStorage> dataStorage,
                  std::shared_ptr<SessionRequestFactory> apiRequestFactory,
                  std::shared_ptr<AsyncService> apiExecutor,
                  std::shared_ptr<RequestHandler> requestHandler,
                  std::shared_ptr<PushHandler> pushHandler,
                  Json::Value callsConfig);

        void processIdleState();

        std::shared_ptr<LoopThread> workerThread_;
        std::shared_ptr<DataStorage> dataStorage_;
        std::shared_ptr<RequestHandler> requestHandler_;
        std::shared_ptr<PushHandler> pushHandler_;
        std::shared_ptr<CallingMessagesSender> callingMessagesSender_;
        std::shared_ptr<CallHolder> callHolder_;
        std::shared_ptr<CallsControllerProvider> callsControllerProvider_;

        CallHolder::CallSubscription callSubscription_;
        std::queue<std::function<void()>> idleCallbacks_;
    };

} // namespace messenger
