#pragma once

#include "call/notifier.h"

#include <yandex_io/callkit/calls/types.h>
#include <yandex_io/callkit/session/session_settings.h>

#include <json/value.h>

#include <deque>
#include <memory>
#include <string>

namespace messenger {

    class AsyncService;
    class AsyncTask;
    class Call;
    class CallHolder;
    class CallingMessagesSender;
    class LoopThread;
    class PushHandler;
    class SessionRequestFactory;

    namespace rtc {
        class MediaSessionFactory;
    } // namespace rtc

    // on: worker thread
    class CallsController: public std::enable_shared_from_this<CallsController> {
    public:
        CallsController(
            std::shared_ptr<LoopThread> workerThread,
            std::shared_ptr<SessionRequestFactory> apiRequestFactory,
            std::shared_ptr<AsyncService> apiExecutor,
            std::shared_ptr<PushHandler> pushHandler,
            std::shared_ptr<CallingMessagesSender> callingMessagesSender,
            std::shared_ptr<rtc::MediaSessionFactory> mediaSessionFactory,
            std::shared_ptr<CallHolder> callHolder,
            std::shared_ptr<PlatformInfoProvider> platformInfo,
            const std::string& userGuid,
            const std::string& receiverDeviceId = {});
        virtual ~CallsController();

        void startOutgoingCall(const std::string& callPayload);
        void handleIncomingCall(proto::CallingMessage message, proto::ServerMessage serverMessage);
        void acceptIncomingCall();
        void declineIncomingCall();
        void hangupCall();

    private:
        void startOutgoingCallInNonPredictedChat(const std::string& callPayload);

        std::shared_ptr<Call> buildOutgoingCall(const std::string& callPayload);
        std::shared_ptr<Call> buildIncomingCall(proto::CallingMessage message);
        void sendDeclineCall(const std::string& callGuid);
        void fetchInfoForIncomingCall();

        std::shared_ptr<LoopThread> workerThread_;
        std::shared_ptr<SessionRequestFactory> apiRequestFactory_;
        std::shared_ptr<AsyncService> apiExecutor_;
        std::shared_ptr<PushHandler> pushHandler_;
        std::shared_ptr<CallingMessagesSender> callingMessagesSender_;
        std::shared_ptr<rtc::MediaSessionFactory> mediaSessionFactory_;
        std::shared_ptr<CallHolder> callHolder_;
        std::shared_ptr<PlatformInfoProvider> platformInfo_;

        std::string userGuid_;
        std::string receiverDeviceId_;

        Json::Value chatInfo_;
        Json::Value userInfo_;
        std::string avatarUrl_;
        std::string displayName_;
        std::string chatId_;
        std::string deviceId_;
        std::shared_ptr<Call> call_;
        std::shared_ptr<AsyncTask> createPrivateChatTask_;
        std::shared_ptr<AsyncTask> fetchChatInfoTask_;
        std::deque<std::string> previousCalls_;
        Notifier::OnEndSubscription onEndSubscription_;
    };

} // namespace messenger
