#pragma once

#include "calling_messages_sender.h"

#include <yandex_io/callkit/calls/types.h>
#include <yandex_io/callkit/session/session_settings.h>

#include <yandex_io/interfaces/user_config/i_user_config_provider.h>
#include <yandex_io/libs/ipc/i_ipc_factory.h>

#include <map>
#include <memory>
#include <string>

namespace messenger {

    class AsyncService;
    class CallHolder;
    class CallsController;
    class DataStorage;
    class LoopThread;
    class PushHandler;
    class RequestHandler;
    class SessionRequestFactory;
    struct PlatformInfoProvider;
    struct SessionSettings;

    namespace rtc {
        class MediaSessionFactory;
    } // namespace rtc

    // on: worker thread
    class CallsControllerProvider
        : public std::enable_shared_from_this<CallsControllerProvider> {
        CREATE_FROM_INIT(CallsControllerProvider);

    public:
        virtual ~CallsControllerProvider();

        void setAllowUsualCalls(bool allowUsualCalls);

        std::shared_ptr<CallsController> getByUserGuid(const std::string& userGuid);
        std::shared_ptr<CallsController> getByDeviceId(const std::string& deviceId);

    private:
        void init(const std::shared_ptr<quasar::ipc::IIpcFactory>& ipcFactory,
                  const SessionSettings& settings,
                  std::shared_ptr<LoopThread> workerThread,
                  std::shared_ptr<DataStorage> dataStorage,
                  std::shared_ptr<SessionRequestFactory> apiRequestFactory,
                  std::shared_ptr<AsyncService> apiExecutor,
                  std::shared_ptr<RequestHandler> requestHandler,
                  std::shared_ptr<PushHandler> pushHandler,
                  std::shared_ptr<CallingMessagesSender> callingMessagesSender,
                  std::shared_ptr<CallHolder> callHolder,
                  std::shared_ptr<quasar::IUserConfigProvider> userConfigProvider,
                  Json::Value callsConfig);

        bool tryUpdateOwnGuid();

        std::chrono::steady_clock::time_point lastRequestUser_;

        std::shared_ptr<LoopThread> workerThread_;
        std::shared_ptr<DataStorage> dataStorage_;
        std::shared_ptr<SessionRequestFactory> apiRequestFactory_;
        std::shared_ptr<AsyncService> apiService_;
        std::shared_ptr<RequestHandler> requestHandler_;
        std::shared_ptr<PushHandler> pushHandler_;
        std::shared_ptr<CallingMessagesSender> callingMessagesSender_;
        std::shared_ptr<rtc::MediaSessionFactory> mediaSessionFactory_;
        std::shared_ptr<CallHolder> callHolder_;
        std::map<std::string /*userGuid*/, std::shared_ptr<CallsController>> controllersForCalls_;
        std::map<std::string /*deviceId*/, std::shared_ptr<CallsController>> controllersForCallsToOwnDevice_;
        std::shared_ptr<PlatformInfoProvider> platformInfo_;
        std::string deviceId_;
        bool allowUsualCalls_;

        std::string ownGuid_;

        CallingMessagesSender::CallingMessageSubscription messageSubscription_;
    };

} // namespace messenger
